//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System.Configuration;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration
{
	/// <summary>
	/// Represents a named <see cref="ConfigurationElement"/> wher the name is the key to a collection.
	/// </summary>
	/// <remarks>
	/// This class is used in conjunction with a <see cref="NamedElementCollection&lt;T&gt;"/>.
	/// </remarks>
	public class NamedConfigurationElement : ConfigurationElement
	{
		private const string nameProperty = "name";

		/// <summary>
		/// Initialize a new instance of a <see cref="NamedConfigurationElement"/> class.
		/// </summary>
		public NamedConfigurationElement()
		{ }

		/// <summary>
		/// Intialize a new instance of a <see cref="NamedConfigurationElement"/> class with a name.
		/// </summary>
		/// <param name="name">The name of the element.</param>
		public NamedConfigurationElement(string name)
		{
			Name = name;
		}

		/// <summary>
		/// Gets or sets the name of the element.
		/// </summary>
		/// <value>
		/// The name of the element.
		/// </value>
		[ConfigurationProperty(nameProperty, IsCollectionKey = true, DefaultValue = "Name", RequiredValue = true)]				
		[StringValidator(MinLength=1)]
		public string Name
		{
			get { return (string)this[nameProperty]; }
			set { this[nameProperty] = value; }
		}
	}
}
